/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.jira.core.JiraCorePlugin;
import com.aptana.jira.core.JiraManager;
import com.aptana.jira.core.JiraUser;
import com.aptana.jira.ui.JiraUIPlugin;
import com.aptana.jira.ui.preferences.Messages;
import com.aptana.ui.preferences.AbstractAccountPageProvider;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JiraPreferencePageProvider
extends AbstractAccountPageProvider {
    private static final String SIGNUP_URL = "https://jira.appcelerator.org/secure/Signup!default.jspa";
    private Group main;
    private Composite loginComposite;
    private Composite logoutComposite;
    private Text usernameText;
    private Text passwordText;
    private Button testButton;
    private Button createAccountButton;
    private Label userLabel;
    private Button logoutButton;

    public JiraPreferencePageProvider() {
    }

    public JiraPreferencePageProvider(IProgressMonitor progressMonitor) {
        super(progressMonitor);
    }

    public Control createContents(Composite parent) {
        this.main = new Group(parent, 0);
        this.main.setText(Messages.JiraPreferencePageProvider_LBL_Jira);
        this.main.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.loginComposite = this.createLoginComponents((Composite)this.main);
        boolean isLoggedOut = this.isLoggedOut();
        this.loginComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).exclude(!isLoggedOut).create());
        this.logoutComposite = this.createLogoutComponents((Composite)this.main);
        this.logoutComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).exclude(isLoggedOut).create());
        return this.main;
    }

    private Composite createLoginComponents(Composite parent) {
        Composite loginComp = new Composite(parent, 0);
        loginComp.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(loginComp, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.JiraPreferencePageProvider_LBL_Username));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JiraPreferencePageProvider.this.updateButtonStates();
            }
        };
        this.usernameText = new Text(loginComp, 2048);
        this.usernameText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.usernameText.addModifyListener(modifyListener);
        this.testButton = new Button(loginComp, 0);
        this.testButton.setText(Messages.JiraPreferencePageProvider_LBL_Validate);
        this.testButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(JiraPreferencePageProvider.getButtonWidthHint(this.testButton), -1).create());
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JiraPreferencePageProvider.this.login(true)) {
                    MessageDialog.openInformation((Shell)UIUtils.getActiveShell(), (String)Messages.JiraPreferencePageProvider_Success_Title, (String)Messages.JiraPreferencePageProvider_Success_Message);
                }
            }
        });
        label = new Label(loginComp, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.JiraPreferencePageProvider_LBL_Password));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.passwordText = new Text(loginComp, 0x400800);
        this.passwordText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.passwordText.addModifyListener(modifyListener);
        this.createAccountButton = new Button(loginComp, 0);
        this.createAccountButton.setText(StringUtil.ellipsify((String)Messages.JiraPreferencePageProvider_LBL_Signup));
        this.createAccountButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(JiraPreferencePageProvider.getButtonWidthHint(this.createAccountButton), -1).create());
        this.createAccountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchBrowserUtil.launchExternalBrowser((String)JiraPreferencePageProvider.SIGNUP_URL);
            }
        });
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.character == '\r' || e.character == '\u1000050') && JiraPreferencePageProvider.this.testButton.isEnabled()) {
                    JiraPreferencePageProvider.this.login(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.usernameText.addKeyListener(keyListener);
        this.passwordText.addKeyListener(keyListener);
        this.updateButtonStates();
        this.adjustWidth();
        return loginComp;
    }

    private Composite createLogoutComponents(Composite parent) {
        Composite logoutComp = new Composite(parent, 0);
        logoutComp.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(logoutComp, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.JiraPreferencePageProvider_LBL_User));
        this.userLabel = new Label(logoutComp, 0);
        this.logoutButton = new Button(logoutComp, 8);
        this.logoutButton.setText(Messages.JiraPreferencePageProvider_LBL_Logout);
        this.logoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraPreferencePageProvider.this.logout();
            }
        });
        this.updateUserText();
        return logoutComp;
    }

    public boolean performOk() {
        if (this.isLoggedOut()) {
            return this.login(false);
        }
        return true;
    }

    protected JiraManager getJiraManager() {
        return JiraCorePlugin.getDefault().getJiraManager();
    }

    private boolean isLoggedOut() {
        return this.getJiraManager().getUser() == null;
    }

    private void updateUserText() {
        JiraUser user = this.getJiraManager().getUser();
        if (user != null) {
            this.userLabel.setText(user.getUsername());
        }
    }

    private void updateButtonStates() {
        this.testButton.setEnabled(!StringUtil.isEmpty((String)this.usernameText.getText()) && !StringUtil.isEmpty((String)this.passwordText.getText()));
    }

    private void adjustWidth() {
        ArrayList<Button> actionControls = new ArrayList<Button>();
        actionControls.add(this.testButton);
        actionControls.add(this.createAccountButton);
        SWTUtils.resizeControlWidthInGrid(actionControls);
    }

    private boolean login(boolean test) {
        final String username = this.usernameText.getText();
        final String password = this.passwordText.getText();
        if (StringUtil.isEmpty((String)username)) {
            if (test) {
                MessageDialog.openError((Shell)this.main.getShell(), (String)Messages.JiraPreferencePageProvider_ERR_InvalidInput_Title, (String)Messages.JiraPreferencePageProvider_ERR_EmptyUsername);
                return false;
            }
            return true;
        }
        if (StringUtil.isEmpty((String)password)) {
            if (test) {
                MessageDialog.openError((Shell)this.main.getShell(), (String)Messages.JiraPreferencePageProvider_ERR_InvalidInput_Title, (String)Messages.JiraPreferencePageProvider_ERR_EmptyPassword);
                return false;
            }
            return true;
        }
        this.setUILocked(true);
        this.firePreValidationStartEvent();
        try {
            try {
                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        block5: {
                            monitor.beginTask(Messages.JiraPreferencePageProvider_ValidateCredentials, -1);
                            try {
                                IStatus status = JiraPreferencePageProvider.this.getJiraManager().login(username, password);
                                if (status.isOK()) {
                                    UIUtils.getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            JiraPreferencePageProvider.this.updateUserText();
                                            JiraPreferencePageProvider.this.layout();
                                        }
                                    });
                                    break block5;
                                }
                                throw new InvocationTargetException((Throwable)new CoreException(status));
                            }
                            finally {
                                if (!monitor.isCanceled()) {
                                    monitor.done();
                                }
                            }
                        }
                    }
                }, (boolean)true, (IProgressMonitor)this.getProgressMonitor(), (Display)UIUtils.getDisplay());
            }
            catch (InvocationTargetException e) {
                if (this.main != null && !this.main.isDisposed()) {
                    MessageDialog.openError((Shell)this.main.getShell(), (String)Messages.JiraPreferencePageProvider_ERR_LoginFailed_Title, (String)e.getTargetException().getMessage());
                }
                this.setUILocked(false);
                this.firePostValidationEndEvent();
                return false;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JiraUIPlugin.getDefault(), (Throwable)e);
                this.setUILocked(false);
                this.firePostValidationEndEvent();
            }
        }
        finally {
            this.setUILocked(false);
            this.firePostValidationEndEvent();
        }
        return true;
    }

    private void logout() {
        this.getJiraManager().logout();
        this.usernameText.setText("");
        this.passwordText.setText("");
        this.usernameText.setFocus();
        this.layout();
    }

    private void layout() {
        boolean isLoggedOut = this.isLoggedOut();
        this.loginComposite.setVisible(isLoggedOut);
        ((GridData)this.loginComposite.getLayoutData()).exclude = !isLoggedOut;
        this.logoutComposite.setVisible(!isLoggedOut);
        ((GridData)this.logoutComposite.getLayoutData()).exclude = isLoggedOut;
        this.main.getParent().layout(true, true);
    }

    private void setUILocked(boolean locked) {
        if (this.main == null || this.main.isDisposed()) {
            return;
        }
        this.usernameText.setEnabled(!locked);
        this.passwordText.setEnabled(!locked);
        this.testButton.setEnabled(!locked);
        this.createAccountButton.setEnabled(!locked);
    }

    private static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

